#include "../common/structs.h"
#include "../common/debug.h"
#include "../common/objects.h"
#include "../common/debug.h"
#include "../common/structs.h"
#include "../common/buffer.h"
#include "../common/colors.h"

extern scene_data* main_scene;

#ifndef FORCE_INLINE

/* {{{ clear_idata_buffer
 * clears the idata buffer */
INLINE void clear_idata_buffer()
{
	intersect_data *ptr;
	intersect_data *length;

	ptr = main_scene->intersect_buffer;
	length = main_scene->intersect_buffer + 
		main_scene->width*main_scene->height;

	while ( ptr < length)
	{
		ptr->obj_num = NOTHING;
		ptr++;
	}
} // }}}

/* {{{ set_color */
INLINE void set_color(int x, int y, color *c)
{
	int offset = array_offset(x, y);
	char *dest_color;
	dest_color = (char*)&main_scene->frame_buffer[offset * 3];

	printd(INSANE, "Writing color %i, %i\n", x, y);
	normalize_color(c);

	*dest_color = (unsigned char)c->r;
	dest_color++;
	*dest_color = (unsigned char)c->g;
	dest_color++;
	*dest_color = (unsigned char)c->b;
} /* }}} */

/* {{{ flush_object_ buffer
 * clears the object buffer */
/* FIXME: old object buffer function- kill
void flush_object_buffer()
{
	int* ptr;
	int* length;
	printd(DEBUG, "{entering flush obj buffer\n");

	ptr = main_scene->obj_buffer;
	
	length = main_scene->obj_buffer + 
		main_scene->width*main_scene->height;

	while(ptr < length)
	{
		*ptr=NOTHING;
		ptr++;
	}
	printd(DEBUG, "}exiting flush obj buffer\n");
} // }}}
*/
/* {{{ flush_color_buffer
 * clears the color buffer */
INLINE void flush_color_buffer()
{
	unsigned char* ptr;
	unsigned char* length;

	ptr=main_scene->frame_buffer;
	length=main_scene->frame_buffer + 
		3*sizeof(char)*main_scene->width*main_scene->height;

	while ( ptr < length)
	{
		*ptr=0;
		ptr++;
	}
} // }}}

/* {{{ array_offset */
/* returns the offset from the beginning of an array based on height and width
 */
INLINE int array_offset(int x, int y)
{
	static int ptr;  //static to avoid redeclaration each call
	printd(INSANE, "Getting offset for: %i, %i\n", x, y);
	ptr = x + y * main_scene->width;
	return ptr;
} // }}}

/* {{{ get_sample */
/* FIXME: old object buffer function- kill it
void get_sample(int x, int y, color* c, int* obj)
{
	int offset;
	char* color;
	int* object;

	offset = array_offset(x, y);
	color = (char*) (offset*3);
	color = (char*) (color) + (int)(&main_scene->frame_buffer[0]);
	object = (int*)(offset * sizeof(int));
	object = (int*)((int)object + (int)(&main_scene->obj_buffer[0]));

	c->r = *color;
	color++;
	c->g = *color;
	color++;
	c->b = *color;

	*obj = *object;

}// }}}
*/

/* {{{ get_object */
/*
 * FIXME: old object buffer function - kill
INLINE int get_object(int x, int y)
{
	int offset = array_offset(x, y);
	int* object;

	object = (int*)(offset * sizeof(int));
	object = (int*)((int)object + (int)(&main_scene->obj_buffer[0]));

	return *object;

}// }}}
*/
/* {{{ get_color */
INLINE void get_color(int x, int y, color* c)
{
	int offset = array_offset(x, y);
	unsigned char* src_color;
	src_color = &main_scene->frame_buffer[offset*3];

	c->r = *src_color;
	src_color++;
	c->g = *src_color;
	src_color++;
	c->b = *src_color;
}// }}}

/* {{{ get_idata */
INLINE intersect_data* get_idata(int x, int y)
{
	int offset = array_offset(x, y);
	void *ptr;

	ptr = (void*) (offset*sizeof(intersect_data));
	return &main_scene->intersect_buffer[offset];
}// }}}

#endif

